import numpy as np 
# inputs would be: x,  color_flag, num_clusters, num_colors, alpha, beta 
# output: return GF_max_additive_violation 
def get_GF_max_additive_violation(x, color_flag, num_clusters, num_colors, alpha, beta):
	x = np.reshape(x , (-1,num_clusters)) 

	cluster_sizes = np.zeros((num_clusters))
	color_cluster_sizes = np.zeros((num_colors,num_clusters))

	# find cluster sizes 
	cluster_sizes = x.sum(axis=0)

	# find color sizes in the clusters 
	for color in range(num_colors):
		color_indices = [i for i, x in enumerate(color_flag) if x ==color]
		x_color_indices =  x[color_indices,:]
		color_cluster_sizes[color,:] = x_color_indices.sum(axis=0)


	max_additive_viol = 0 
	for clust in range(num_clusters): 
		for color in range(num_colors):
			max_upper = color_cluster_sizes[color,clust] - alpha[color]*cluster_sizes[clust] 
			max_upper = max(max_upper,0) 

			max_lower  = beta[color]*cluster_sizes[clust] - color_cluster_sizes[color,clust] 
			max_lower = max(max_lower,0) 

			add_viol = max(max_upper,max_lower)


			if add_viol >max_additive_viol:
				max_additive_viol = add_viol



	return max_additive_viol




# inputs would be: center_colors,  num_clusters, num_colors, upperBound, lowerBound
# output: return DS_max_additive_violation 
# center_colors is the number of centers of each color center_colors[i] = #centers of color i 
def get_DS_max_additive_violation(center_colors,num_clusters, num_colors, upperBound, lowerBound):
	max_additive_viol = 0 


	for color in range(num_colors):
		max_upper = center_colors[color] - upperBound[color]
		max_upper = max(max_upper,0) 


		max_lower  = lowerBound[color] - center_colors[color]
		max_lower = max(max_lower,0) 

		add_viol = max(max_upper,max_lower)

		if add_viol >max_additive_viol:
			max_additive_viol = add_viol


	return max_additive_viol
